/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.cards.curses.Decay;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.helpers.ScreenShake;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class ForgottenAltar
extends AbstractImageEvent {
    public static final String ID = "Forgotten Altar";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Forgotten Altar");
    public static final String NAME = ForgottenAltar.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = ForgottenAltar.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = ForgottenAltar.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String DIALOG_2 = DESCRIPTIONS[1];
    private static final String DIALOG_3 = DESCRIPTIONS[2];
    private static final String DIALOG_4 = DESCRIPTIONS[3];
    private static final int IRONCLAD_HP_LOSS = 20;
    private static final int SILENT_HP_LOSS = 14;
    private static final int MAX_HP_GAIN = 5;

    public ForgottenAltar() {
        super(NAME, DIALOG_1, "images/events/forgottenAltar.jpg");
        if (AbstractDungeon.player.hasRelic("Golden Idol")) {
            GenericEventDialog.setDialogOption(OPTIONS[0], !AbstractDungeon.player.hasRelic("Golden Idol"));
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[1], !AbstractDungeon.player.hasRelic("Golden Idol"));
        }
        if (AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.IRONCLAD) {
            GenericEventDialog.setDialogOption(OPTIONS[2] + 5 + OPTIONS[3] + 20 + OPTIONS[4]);
        } else if (AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.THE_SILENT) {
            GenericEventDialog.setDialogOption(OPTIONS[2] + 5 + OPTIONS[3] + 14 + OPTIONS[4]);
        } else if (AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.CROWBOT) {
            GenericEventDialog.setDialogOption(OPTIONS[5], true);
        }
        GenericEventDialog.setDialogOption(OPTIONS[6], CardLibrary.getCopy("Decay"));
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        this.gainChalice();
                        this.showProceedScreen(DIALOG_2);
                        CardCrawlGame.sound.play("HEAL_1");
                        this.logMetric("Gave Idol");
                        break block0;
                    }
                    case 1: {
                        AbstractDungeon.player.increaseMaxHp(5, false);
                        if (AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.IRONCLAD) {
                            AbstractDungeon.player.damage(new DamageInfo(null, 20));
                        } else if (AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.THE_SILENT) {
                            AbstractDungeon.player.damage(new DamageInfo(null, 14));
                        }
                        CardCrawlGame.sound.play("HEAL_3");
                        this.showProceedScreen(DIALOG_3);
                        this.logMetric("Shed Blood");
                        break block0;
                    }
                    case 2: {
                        CardCrawlGame.sound.play("BLUNT_HEAVY");
                        CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.HIGH, ScreenShake.ShakeDur.MED, true);
                        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Decay(), Settings.WIDTH / 2, Settings.HEIGHT / 2));
                        UnlockTracker.markCardAsSeen("Decay");
                        this.showProceedScreen(DIALOG_4);
                        this.logMetric("Smashed Altar");
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void gainChalice() {
        int relicAtIndex = 0;
        for (int i = 0; i < AbstractDungeon.player.relics.size(); ++i) {
            if (!AbstractDungeon.player.relics.get((int)i).relicId.equals("Golden Idol")) continue;
            relicAtIndex = i;
            break;
        }
        AbstractDungeon.player.relics.get(relicAtIndex).onUnequip();
        AbstractRelic bloodyIdol = RelicLibrary.getRelic("Bloody Idol").makeCopy();
        bloodyIdol.instantObtain(AbstractDungeon.player, relicAtIndex, false);
    }

    public void logMetric(String result) {
        AbstractEvent.logMetric(ID, result);
    }
}

